//%attributes = {"publishedSql":true}
// Method: _lnk_ CREATE
// 2005.10.17-14:38:06 / ME
// © Copyright 2005 Manage Applications
// Purpose: 
// Creates links from the current record of a given table
// or from all records of its current selection
// to the current record of a given table
// or to all records of its current selection
// ------------------------------------------------------------

C_LONGINT:C283($_lnk_lFromTbl; $1; $_lnk_lFromSel; $2; $_lnk_lToTbl; $3; $_lnk_lToSel; $4; $_lnk_lFromSelSize; $_lnk_lFromLoaded; $_lnk_lToSelSize; $_lnk_lToLoaded)

$_lnk_lFromTbl:=_rd_ To4DTblNum($1)  // the number of the table from which creating links ('FROM')
$_lnk_lFromSel:=$2  // use current record or current selection in 'FROM' table? 
// kCurrentSelection = use whole selection, kCurrentRecord = use current record

$_lnk_lToTbl:=_rd_ To4DTblNum($3)  // the number of the table to which creating links ('TO')
$_lnk_lToSel:=$4  // use current record or current selection in 'TO' table?
// kCurrentSelection = use whole selection, kCurrentRecord = use current record

// ME 2006-01-27 selection has to be made or checked in calling method
$_lnk_lFromSelSize:=_sel RecsInSel($_lnk_lFromTbl)
$_lnk_lFromLoaded:=_rec Loaded($_lnk_lFromTbl)
// must not try to use selection if sel size is 0
If (($_lnk_lFromSel=kCurrentSelection) & ($_lnk_lFromLoaded=kTrue) & ($_lnk_lFromSelSize<0))
	$_lnk_lFromSel:=kCurrentRecord
	$_lnk_lFromSelSize:=1
End if 
$_lnk_lToSelSize:=_sel RecsInSel($_lnk_lToTbl)
$_lnk_lToLoaded:=_rec Loaded($_lnk_lToTbl)
// must not try to use selection if sel size is 0
If (($_lnk_lToSel=kCurrentSelection) & ($_lnk_lToLoaded=kTrue) & ($_lnk_lToSelSize<1))
	$_lnk_lToSel:=kCurrentRecord
	$_lnk_lToSelSize:=1
End if 

Case of 
	: ($_lnk_lFromTbl=$_lnk_lToTbl)
		_err MESSAGE(_lang Current("Attempting to create automatic link to same table")+": "+_tbl Name($_lnk_lFromTbl); Current method name:C684; kTrue)
	: (($_lnk_lFromSelSize<1) & ($_lnk_lFromLoaded=kFalse))
		_err MESSAGE(_lang Current("No records in selection for table")+": "+_tbl Name($_lnk_lFromTbl); Current method name:C684; kTrue)
	: (($_lnk_lToSelSize<1) & ($_lnk_lToLoaded=kFalse))
		_err MESSAGE(_lang Current("No records in selection for table")+": "+_tbl Name($_lnk_lToTbl); Current method name:C684; kTrue)
	Else 
		C_LONGINT:C283($_lnk_lFromIndex; $_lnk_lFromCount; $_lnk_lToIndex; $_lnk_lToCount)
		
		If ($_lnk_lFromSel=kCurrentSelection)  // use whole selection in from table
			$_lnk_lFromCount:=_sel RecsInSel($_lnk_lFromTbl)
			_rec PUSH($_lnk_lFromTbl)  // to restore current record afterwards
			_rec FIRST($_lnk_lFromTbl)  // start from the beginning of the selection
		Else   // use current record in from table
			$_lnk_lFromCount:=1
			If (_rec Loaded($_lnk_lFromTbl)=kFalse)  //PM: 2006-01-26
				TRACE:C157  //why not loaded?      
				_rec LOAD($_lnk_lFromTbl)
			End if 
		End if 
		
		If ($_lnk_lToSel=kCurrentSelection)  // use whole selection in to table
			$_lnk_lToCount:=_sel RecsInSel($_lnk_lToTbl)
			_rec PUSH($_lnk_lToTbl)  // to restore current record afterwards
			_rec FIRST($_lnk_lToTbl)  // start from the beginning of the selection
		Else   // use current record in to table
			$_lnk_lToCount:=1
			If (_rec Loaded($_lnk_lToTbl)=kFalse)  //PM: 2006-01-26
				TRACE:C157  //why not loaded?            
				_rec LOAD($_lnk_lToTbl)
			End if 
		End if 
		
		C_LONGINT:C283($_lnk_lUUIDFldNum)
		C_TEXT:C284($_lnk_tFromUUID; $_lnk_tToUUID; $_lnk_tInfo)
		
		// create the links
		For ($_lnk_lFromIndex; 1; $_lnk_lFromCount)
			For ($_lnk_lToIndex; 1; $_lnk_lToCount)
				$_lnk_lUUIDFldNum:=_tbl_ UUIDFldNum($_lnk_lFromTbl)
				$_lnk_tFromUUID:=_fld ValueStr($_lnk_lUUIDFldNum)
				$_lnk_lUUIDFldNum:=_tbl_ UUIDFldNum($_lnk_lToTbl)
				$_lnk_tToUUID:=_fld ValueStr($_lnk_lUUIDFldNum)
				$_lnk_tInfo:=_lang Current("Automatic link")+ksSpace+_tbl Name($_lnk_lFromTbl)+" -- "+_tbl Name($_lnk_lToTbl)
				_lnk_ FROM_UUID_CREATE($_lnk_tFromUUID; $_lnk_tToUUID; $_lnk_tInfo)
				If ($_lnk_lToIndex<$_lnk_lToCount)
					_rec NEXT($_lnk_lToTbl)
				End if 
			End for 
			If ($_lnk_lFromIndex<$_lnk_lFromCount)
				_rec NEXT($_lnk_lFromTbl)
				If ($_lnk_lToCount>1)
					_rec FIRST($_lnk_lToTbl)
				End if 
			End if 
		End for 
		
		If ($_lnk_lFromSel=kCurrentSelection)  // use whole selection in from table
			_rec POP($_lnk_lFromTbl)  // restore current record
		End if 
		If ($_lnk_lToSel=kCurrentSelection)  // use whole selection in to table
			_rec POP($_lnk_lToTbl)  // restore current record
		End if 
End case 
